import vtk.vtkDataArray;
import vtk.vtkDataSet;
import vtk.vtkFloatArray;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkProgrammableFilter;
import vtk.vtkPolyData;

public class Test3 extends vtkProgrammableFilter {
	private double factor;

	public Test3() {
		SetExecuteMethod(this, "compute");
	}
	public void SetParam (double p_factor) {
		factor = p_factor;
	}

	public void compute() {
		vtkPolyData polyDataInput = GetPolyDataInput();
		vtkPolyData polyDataOutput = GetPolyDataOutput();
		polyDataOutput.CopyStructure(polyDataInput);
		polyDataOutput.GetPointData().PassData(polyDataInput.GetPointData());
		polyDataOutput.GetCellData().PassData(polyDataInput.GetCellData());
		vtkPoints inputPoints = polyDataInput.GetPoints();
		vtkPoints outputPoints = new vtkPoints();
		outputPoints.SetNumberOfPoints(inputPoints.GetNumberOfPoints());
		polyDataOutput.SetPoints(outputPoints);
		//
		vtkFloatArray data = (vtkFloatArray)polyDataOutput.GetPointData().GetScalars();
		//
		for (int i = 0; i < inputPoints.GetNumberOfPoints(); i++) {
			if (i%10 == 0)
				outputPoints.SetPoint(i, inputPoints.GetPoint(i)[0],inputPoints.GetPoint(i)[1],inputPoints.GetPoint(i)[2]+data.GetTuple1(i)*factor*2);
			else
				outputPoints.SetPoint(i, inputPoints.GetPoint(i)[0],inputPoints.GetPoint(i)[1],inputPoints.GetPoint(i)[2]+data.GetTuple1(i)*factor);
		}
	}
}